#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.HL7AL.UnitTests
{
	[TestFixture]
	public class HL7AL_VbecsOmgMessage : BaseTest
	{
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
		}

		[TearDown]
		protected void TearDown()
		{}

		[Test]
		public void Constructor_Pass()
		{
			VbecsOmgMessage omgMsg = new VbecsOmgMessage();
			Assert.IsNotNull(omgMsg);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void Constructor_Fail()
		{}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void PatientOrderUpdate_Pass()
		{}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void PatientOrderUpdate_Fail()
		{
			VbecsOmgMessage omgMsg = new VbecsOmgMessage();
			omgMsg.PatientOrderUpdate(null);
		}
	}
}
#endif
